/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.model.OcelotTailModel;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.class_5601;
import net.minecraft.class_5605;
import net.minecraft.class_582;

public class OcelotTailElement
extends ModelElementBase {
    public static int tailLength;
    public static int animationSpeed;
    private final class_5601 animatedOcelot;

    public OcelotTailElement(ModelLayerRegistry modelLayerRegistry) {
        this.animatedOcelot = modelLayerRegistry.register("animated_ocelot");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Takes away the stick tails of the current ocelots and gives them something nicer instead.", "Fully animated flowing tails that move while they stand or run."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(class_582.class, () -> new OcelotTailModel(bakery.bakeLayer(this.animatedOcelot)));
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedOcelot, () -> OcelotTailModel.createAnimatedBodyMesh(class_5605.field_27715));
    }

    @Override
    public void setupModelConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Define tail length.").defineInRange("tail_length", 15, 1, 15), v -> {
            tailLength = v;
        });
        callback.accept((Supplier)builder.comment("Animation swing speed for tail.").defineInRange("animation_speed", 7, 1, 20), v -> {
            animationSpeed = v;
        });
    }
}

